/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.core.useragent.handlers;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.media.MediaManager;
import net.sourceforge.peers.sdp.Codec;
import net.sourceforge.peers.sdp.MediaDestination;
import net.sourceforge.peers.sdp.NoCodecException;
import net.sourceforge.peers.sdp.SessionDescription;
import net.sourceforge.peers.sip.Utils;
import net.sourceforge.peers.sip.core.useragent.RequestManager;
import net.sourceforge.peers.sip.core.useragent.SipListener;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.core.useragent.handlers.DialogMethodHandler;
import net.sourceforge.peers.sip.syntaxencoding.NameAddress;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.syntaxencoding.SipURI;
import net.sourceforge.peers.sip.syntaxencoding.SipUriSyntaxException;
import net.sourceforge.peers.sip.transaction.ClientTransaction;
import net.sourceforge.peers.sip.transaction.ClientTransactionUser;
import net.sourceforge.peers.sip.transaction.InviteClientTransaction;
import net.sourceforge.peers.sip.transaction.InviteServerTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransaction;
import net.sourceforge.peers.sip.transaction.ServerTransactionUser;
import net.sourceforge.peers.sip.transaction.Transaction;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transactionuser.Dialog;
import net.sourceforge.peers.sip.transactionuser.DialogManager;
import net.sourceforge.peers.sip.transport.MessageSender;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.TransportManager;

public class InviteHandler
extends DialogMethodHandler
implements ServerTransactionUser,
ClientTransactionUser {
    public static final int TIMEOUT = 100;
    private MediaDestination mediaDestination;
    private Timer ackTimer = new Timer(this.getClass().getSimpleName() + " Ack " + Timer.class.getSimpleName());
    private boolean initialIncomingInvite;

    public InviteHandler(UserAgent userAgent, DialogManager dialogManager, TransactionManager transactionManager, TransportManager transportManager, Logger logger) {
        super(userAgent, dialogManager, transactionManager, transportManager, logger);
    }

    public void handleInitialInvite(SipRequest sipRequest) {
        String responseTo;
        List<String> peers;
        this.initialIncomingInvite = true;
        SipResponse sipResponse = this.buildGenericResponse(sipRequest, 180, "Ringing");
        Dialog dialog = this.buildDialogForUas(sipResponse, sipRequest);
        InviteServerTransaction inviteServerTransaction = (InviteServerTransaction)this.transactionManager.createServerTransaction(sipResponse, this.userAgent.getSipPort(), "UDP", this, sipRequest);
        inviteServerTransaction.start();
        inviteServerTransaction.receivedRequest(sipRequest);
        inviteServerTransaction.sendReponse(sipResponse);
        dialog.receivedOrSent1xx();
        SipListener sipListener = this.userAgent.getSipListener();
        if (sipListener != null) {
            sipListener.incomingCall(sipRequest, sipResponse);
        }
        if (!(peers = this.userAgent.getPeers()).contains(responseTo = sipRequest.getSipHeaders().get(new SipHeaderFieldName("From")).getValue())) {
            peers.add(responseTo);
        }
    }

    public void handleReInvite(SipRequest sipRequest, Dialog dialog) {
        this.logger.debug("handleReInvite");
        this.initialIncomingInvite = false;
        SipHeaders sipHeaders = sipRequest.getSipHeaders();
        SipHeaderFieldValue contact = sipHeaders.get(new SipHeaderFieldName("Contact"));
        if (contact != null) {
            String contactStr = contact.getValue();
            if (contactStr.indexOf(60) > -1) {
                contactStr = NameAddress.nameAddressToUri(contactStr);
            }
            dialog.setRemoteTarget(contactStr);
        }
        this.sendSuccessfulResponse(sipRequest, dialog);
    }

    private DatagramSocket getDatagramSocket() {
        DatagramSocket datagramSocket = this.userAgent.getMediaManager().getDatagramSocket();
        if (datagramSocket == null) {
            datagramSocket = AccessController.doPrivileged(new PrivilegedAction<DatagramSocket>(){

                @Override
                public DatagramSocket run() {
                    DatagramSocket datagramSocket = null;
                    int rtpPort = InviteHandler.this.userAgent.getConfig().getRtpPort();
                    try {
                        if (rtpPort == 0) {
                            int localPort = -1;
                            while (localPort % 2 != 0) {
                                datagramSocket = new DatagramSocket();
                                localPort = datagramSocket.getLocalPort();
                                if (localPort % 2 == 0) continue;
                                datagramSocket.close();
                            }
                        } else {
                            datagramSocket = new DatagramSocket(rtpPort);
                        }
                    }
                    catch (SocketException e) {
                        InviteHandler.this.logger.error("cannot create datagram socket ", e);
                    }
                    return datagramSocket;
                }
            });
            this.logger.debug("new rtp DatagramSocket " + datagramSocket.hashCode());
            try {
                datagramSocket.setSoTimeout(100);
            }
            catch (SocketException e) {
                this.logger.error("cannot set timeout on datagram socket ", e);
            }
            this.userAgent.getMediaManager().setDatagramSocket(datagramSocket);
        }
        return datagramSocket;
    }

    private synchronized void sendSuccessfulResponse(SipRequest sipRequest, Dialog dialog) {
        ServerTransaction serverTransaction;
        SipHeaders reqHeaders = sipRequest.getSipHeaders();
        SipHeaderFieldValue contentType = reqHeaders.get(new SipHeaderFieldName("Content-Type"));
        if ("application/sdp".equals(contentType)) {
            // empty if block
        }
        SipResponse sipResponse = RequestManager.generateResponse(sipRequest, dialog, 200, "OK");
        byte[] offerBytes = sipRequest.getBody();
        try {
            SessionDescription answer;
            DatagramSocket datagramSocket = this.getDatagramSocket();
            if (offerBytes != null && contentType != null && "application/sdp".equals(contentType.getValue())) {
                try {
                    SessionDescription offer = this.sdpManager.parse(offerBytes);
                    answer = this.sdpManager.createSessionDescription(offer, datagramSocket.getLocalPort());
                    this.mediaDestination = this.sdpManager.getMediaDestination(offer);
                }
                catch (NoCodecException e) {
                    answer = this.sdpManager.createSessionDescription(null, datagramSocket.getLocalPort());
                }
            } else {
                answer = this.sdpManager.createSessionDescription(null, datagramSocket.getLocalPort());
            }
            sipResponse.setBody(answer.toString().getBytes());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
        SipHeaders respHeaders = sipResponse.getSipHeaders();
        respHeaders.add(new SipHeaderFieldName("Content-Type"), new SipHeaderFieldValue("application/sdp"));
        ArrayList<String> routeSet = dialog.getRouteSet();
        if (routeSet != null) {
            SipHeaderFieldName recordRoute = new SipHeaderFieldName("Record-Route");
            for (String route : routeSet) {
                respHeaders.add(recordRoute, new SipHeaderFieldValue(route));
            }
        }
        if ((serverTransaction = this.transactionManager.getServerTransaction(sipRequest)) == null) {
            serverTransaction = (InviteServerTransaction)this.transactionManager.createServerTransaction(sipResponse, this.userAgent.getSipPort(), "UDP", this, sipRequest);
        }
        serverTransaction.start();
        serverTransaction.receivedRequest(sipRequest);
        serverTransaction.sendReponse(sipResponse);
    }

    public void acceptCall(SipRequest sipRequest, Dialog dialog) {
        this.sendSuccessfulResponse(sipRequest, dialog);
        dialog.receivedOrSent2xx();
    }

    public void rejectCall(SipRequest sipRequest) {
        SipHeaders reqHeaders = sipRequest.getSipHeaders();
        SipHeaderFieldValue callId = reqHeaders.get(new SipHeaderFieldName("Call-ID"));
        Dialog dialog = this.dialogManager.getDialog(callId.getValue());
        SipResponse sipResponse = RequestManager.generateResponse(sipRequest, dialog, 486, "Busy Here");
        ServerTransaction serverTransaction = this.transactionManager.getServerTransaction(sipRequest);
        serverTransaction.start();
        serverTransaction.receivedRequest(sipRequest);
        serverTransaction.sendReponse(sipResponse);
        dialog.receivedOrSent300To699();
        this.userAgent.getMediaManager().setDatagramSocket(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientTransaction preProcessInvite(SipRequest sipRequest) throws SipUriSyntaxException {
        DatagramSocket datagramSocket;
        InetAddress inetAddress;
        SipURI sipUri;
        int port;
        String reqUriTransport;
        SipHeaders requestHeaders = sipRequest.getSipHeaders();
        SipURI destinationUri = RequestManager.getDestinationUri(sipRequest, this.logger);
        String transport = "UDP";
        Hashtable<String, String> params = destinationUri.getUriParameters();
        if (params != null && (reqUriTransport = params.get("transport")) != null) {
            transport = reqUriTransport;
        }
        if ((port = destinationUri.getPort()) == -1) {
            port = 5060;
        }
        if ((sipUri = this.userAgent.getConfig().getOutboundProxy()) == null) {
            sipUri = destinationUri;
        }
        try {
            inetAddress = InetAddress.getByName(sipUri.getHost());
        }
        catch (UnknownHostException e) {
            throw new SipUriSyntaxException("unknown host: " + sipUri.getHost(), e);
        }
        ClientTransaction clientTransaction = this.transactionManager.createClientTransaction(sipRequest, inetAddress, port, transport, null, this);
        InviteHandler inviteHandler = this;
        synchronized (inviteHandler) {
            datagramSocket = this.getDatagramSocket();
        }
        try {
            SessionDescription sessionDescription = this.sdpManager.createSessionDescription(null, datagramSocket.getLocalPort());
            sipRequest.setBody(sessionDescription.toString().getBytes());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
        requestHeaders.add(new SipHeaderFieldName("Content-Type"), new SipHeaderFieldValue("application/sdp"));
        return clientTransaction;
    }

    public void preProcessReInvite(SipRequest sipRequest) {
    }

    @Override
    public void errResponseReceived(SipResponse sipResponse) {
        String callId;
        List<String> guiClosedCallIds;
        int statusCode;
        Dialog dialog = this.dialogManager.getDialog(sipResponse);
        if (dialog != null) {
            dialog.receivedOrSent300To699();
            this.dialogManager.removeDialog(dialog.getId());
        }
        if ((statusCode = sipResponse.getStatusCode()) == 401 || statusCode == 407 && !this.challenged) {
            InviteClientTransaction inviteClientTransaction = (InviteClientTransaction)this.transactionManager.getClientTransaction(sipResponse);
            SipRequest sipRequest = inviteClientTransaction.getRequest();
            String password = this.userAgent.getConfig().getPassword();
            if (password != null && !"".equals(password.trim())) {
                this.challengeManager.handleChallenge(sipRequest, sipResponse);
            }
            this.challenged = true;
            return;
        }
        this.challenged = false;
        SipListener sipListener = this.userAgent.getSipListener();
        if (sipListener != null) {
            sipListener.error(sipResponse);
        }
        if ((guiClosedCallIds = this.userAgent.getUac().getGuiClosedCallIds()).contains(callId = Utils.getMessageCallId(sipResponse))) {
            guiClosedCallIds.remove(callId);
        }
        this.userAgent.getMediaManager().setDatagramSocket(null);
    }

    @Override
    public void provResponseReceived(SipResponse sipResponse, Transaction transaction) {
        String callId;
        List<String> guiClosedCallIds;
        SipHeaderFieldValue to;
        String toTag;
        Dialog dialog = this.dialogManager.getDialog(sipResponse);
        boolean isFirstProvRespWithToTag = false;
        if (dialog == null && (toTag = (to = sipResponse.getSipHeaders().get(new SipHeaderFieldName("To"))).getParam(new SipHeaderParamName("tag"))) != null) {
            dialog = this.dialogManager.createDialog(sipResponse);
            isFirstProvRespWithToTag = true;
        }
        if (dialog != null) {
            this.buildOrUpdateDialogForUac(sipResponse, transaction);
        }
        if (isFirstProvRespWithToTag) {
            SipListener sipListener = this.userAgent.getSipListener();
            if (sipListener != null) {
                sipListener.ringing(sipResponse);
            }
            dialog.receivedOrSent1xx();
        }
        if ((guiClosedCallIds = this.userAgent.getUac().getGuiClosedCallIds()).contains(callId = Utils.getMessageCallId(sipResponse))) {
            SipRequest sipRequest = transaction.getRequest();
            this.logger.debug("cancel after prov response: sipRequest " + sipRequest + ", sipResponse " + sipResponse);
            this.userAgent.terminate(sipRequest);
        }
    }

    @Override
    public void successResponseReceived(SipResponse sipResponse, Transaction transaction) {
        InetAddress inetAddress;
        SipURI sipUri;
        int port;
        String reqUriTransport;
        Dialog dialog;
        String responseTo;
        SipHeaders responseHeaders = sipResponse.getSipHeaders();
        String cseq = responseHeaders.get(new SipHeaderFieldName("CSeq")).getValue();
        String method = cseq.substring(cseq.trim().lastIndexOf(32) + 1);
        if (!"INVITE".equals(method)) {
            return;
        }
        this.challenged = false;
        List<String> peers = this.userAgent.getPeers();
        if (!peers.contains(responseTo = responseHeaders.get(new SipHeaderFieldName("To")).getValue())) {
            peers.add(responseTo);
            this.ackTimer.schedule((TimerTask)new DialogMethodHandler.AckTimerTask(responseTo), 32000L);
        }
        if ((dialog = this.dialogManager.getDialog(sipResponse)) != null) {
            dialog.setRouteSet(this.computeRouteSet(sipResponse.getSipHeaders()));
        }
        dialog = this.buildOrUpdateDialogForUac(sipResponse, transaction);
        SipListener sipListener = this.userAgent.getSipListener();
        if (sipListener != null) {
            sipListener.calleePickup(sipResponse);
        }
        SessionDescription sessionDescription = this.sdpManager.parse(sipResponse.getBody());
        try {
            this.mediaDestination = this.sdpManager.getMediaDestination(sessionDescription);
        }
        catch (NoCodecException e) {
            this.logger.error(e.getMessage(), e);
        }
        String remoteAddress = this.mediaDestination.getDestination();
        int remotePort = this.mediaDestination.getPort();
        Codec codec = this.mediaDestination.getCodec();
        String localAddress = this.userAgent.getConfig().getLocalInetAddress().getHostAddress();
        this.userAgent.getMediaManager().successResponseReceived(localAddress, remoteAddress, remotePort, codec);
        dialog.receivedOrSent2xx();
        SipRequest ack = dialog.buildSubsequentRequest("ACK");
        SipHeaders ackHeaders = ack.getSipHeaders();
        SipHeaderFieldName cseqName = new SipHeaderFieldName("CSeq");
        SipHeaderFieldValue ackCseq = ackHeaders.get(cseqName);
        SipRequest request = transaction.getRequest();
        SipHeaders requestHeaders = request.getSipHeaders();
        SipHeaderFieldValue requestCseq = requestHeaders.get(cseqName);
        ackCseq.setValue(requestCseq.toString().replace("INVITE", "ACK"));
        SipHeaderFieldValue via = new SipHeaderFieldValue("");
        SipHeaderParamName branchIdName = new SipHeaderParamName("branch");
        via.addParam(branchIdName, Utils.generateBranchId());
        ackHeaders.add(new SipHeaderFieldName("Via"), via, 0);
        if (request.getBody() == null && sipResponse.getBody() != null) {
            ack.setBody(sipResponse.getBody());
        }
        SipURI destinationUri = RequestManager.getDestinationUri(ack, this.logger);
        this.challengeManager.postProcess(ack);
        String transport = "UDP";
        Hashtable<String, String> params = destinationUri.getUriParameters();
        if (params != null && (reqUriTransport = params.get("transport")) != null) {
            transport = reqUriTransport;
        }
        if ((port = destinationUri.getPort()) == -1) {
            port = 5060;
        }
        if ((sipUri = this.userAgent.getConfig().getOutboundProxy()) == null) {
            sipUri = destinationUri;
        }
        try {
            inetAddress = InetAddress.getByName(sipUri.getHost());
        }
        catch (UnknownHostException e) {
            this.logger.error("unknown host: " + sipUri.getHost(), e);
            return;
        }
        try {
            MessageSender sender = this.transportManager.createClientTransport(ack, inetAddress, port, transport);
            sender.sendMessage(ack);
        }
        catch (IOException e) {
            this.logger.error("input/output error", e);
        }
        List<String> guiClosedCallIds = this.userAgent.getUac().getGuiClosedCallIds();
        String callId = Utils.getMessageCallId(sipResponse);
        if (guiClosedCallIds.contains(callId)) {
            this.userAgent.terminate(request);
        }
    }

    public void handleAck(SipRequest ack, Dialog dialog) {
        this.logger.debug("handleAck");
        if (this.mediaDestination == null) {
            SipHeaders reqHeaders = ack.getSipHeaders();
            SipHeaderFieldValue contentType = reqHeaders.get(new SipHeaderFieldName("Content-Type"));
            byte[] offerBytes = ack.getBody();
            if (offerBytes != null && contentType != null && "application/sdp".equals(contentType.getValue())) {
                try {
                    SessionDescription answer = this.sdpManager.parse(offerBytes);
                    this.mediaDestination = this.sdpManager.getMediaDestination(answer);
                }
                catch (NoCodecException e) {
                    this.logger.error(e.getMessage(), e);
                    return;
                }
            }
        }
        String destAddress = this.mediaDestination.getDestination();
        int destPort = this.mediaDestination.getPort();
        Codec codec = this.mediaDestination.getCodec();
        MediaManager mediaManager = this.userAgent.getMediaManager();
        if (this.initialIncomingInvite) {
            mediaManager.handleAck(destAddress, destPort, codec);
        } else {
            mediaManager.updateRemote(destAddress, destPort, codec);
        }
    }

    @Override
    public void transactionTimeout(ClientTransaction clientTransaction) {
    }

    @Override
    public void transactionTransportError() {
    }

    @Override
    public void transactionFailure() {
    }
}

